<?php $__env->startSection('title', $title); ?>
<?php $__env->startPush('css'); ?>
<style type="text/css">
    .required{
        color: red;
        font-weight: 600;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('maincontent'); ?>


<div class="content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo e($title); ?> List</h5>
                            <button class="btn btn-info btn-sm" style="margin-top: -45px; float: right;" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Add New</button>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Outlet Name</th>
                                        <th>Address</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $outlets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$key); ?></td>
                                        <td><?php echo e($list->name); ?></td>
                                        <td><?php echo e($list->address); ?></td>
                                        <td>
                                            <?php if($list->status == 1): ?>
                                            <button class="btn btn-success btn-sm">Active</button>
                                            <?php else: ?>
                                            <button class="btn btn-danger btn-sm">In Active</button>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <button class="btn btn-primary btn-sm" onclick="editData(<?php echo e(json_encode($list)); ?>)"><i class="fa fa-edit"></i></button>
                                            <button class="btn btn-danger waves-effect btn-sm" onclick="return deleteCertification(<?php echo $list->id  ; ?>)"><i style="font-size: 15px;" class="fa fa-trash"></i></button>
                                            <form id="delete-form-<?php echo e($list->id); ?>" action="<?php echo e(url('outlets',$list->id  )); ?>" method="post" style="display: none;">
                                                <?php echo method_field('DELETE'); ?>
                                                <?php echo csrf_field(); ?>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div><!--End Row-->
        <div class="overlay toggle-menu"></div>

        <div class="modal fade" id="addModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Add <?php echo e($title); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="<?php echo e(url('outlets')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Name <span class="required">*</span></label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Product Name" required>
                            </div>
                            <div class="form-group">
                                <label>Address <span class="required">*</span></label>
                                <textarea class="form-control" required="" name="address" placeholder="Enter Address"></textarea>
                            </div>
                            <div class="form-group">
                                <label>Status <span class="required">*</span></label>
                                <select class="form-control" name="status" required="">
                                    <option value="">Select Status</option>
                                    <option value="1">Active</option>
                                    <option value="2">InActive</option>
                                </select>
                            </div>

                        </div>  
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>

        
        <div class="modal fade" id="editModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Update <?php echo e($title); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="<?php echo e(url('outlets-update')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                           
                            <div class="form-group">
                                <label>Name <span class="required">*</span></label>
                                <input type="text" id="name" class="form-control" name="name" placeholder="Enter Product Name" required>
                            </div>
                            <div class="form-group">
                                <label>Address <span class="required">*</span></label>
                                <textarea class="form-control" id="address" required="" name="address" placeholder="Enter Address"></textarea>
                            </div>
                            <div class="form-group">
                                <label>Status <span class="required">*</span></label>
                                <select class="form-control" id="status" name="status" required="">
                                    <option value="">Select Status</option>
                                    <option value="1">Active</option>
                                    <option value="2">InActive</option>
                                </select>
                            </div>
                        </div>
                        <input type="hidden" name="outlet_id" id="outlet_id">
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>
    </div>
    <!--end overlay-->
</div>
<!-- End container-fluid-->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<script type="text/javascript">

    function editData(value){
        $('#editModal').modal('show')
        $('#name').val(value.name)
        $('#address').val(value.address)
        $('#status').val(value.status)
        $('#outlet_id').val(value.id)
    }

</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shagmt/pos.wellfoodsylhet.com/resources/views/admin/pages/outlets.blade.php ENDPATH**/ ?>