@extends('admin.master')
@section('title','User List')
@section('maincontent')
<div class="content-wrapper">
    <!--Start Dashboard Content-->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="container">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-md">
                                <a href="#" data-toggle="modal" data-target="#modal-animation-3"> <i
                                        class="fa fa-plus"></i> Create a User</a>
                            </div>
                            <div class="col-md" style="text-align:right;">
                                <a href="#" onclick="location.reload();">&nbsp;<i class="fa fa-refresh"></i>&nbsp;Reload
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container">
                    <div class="row">
                        <div class="form-group">
                            <input type="text" name="serach" id="serach" placeholder="Search...." />
                        </div>

                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped table-dark table-hover" style="width: 100%; color:#fff;">
                            <thead>
                                <tr style="background-color: #223035;color: white; border-radius: 0 6px 0 0;">
                                    <th width="5%" class="sorting" data-sorting_type="asc" data-column_name="user_id"
                                        style="cursor: pointer">SL <span id="id_icon"></span></th>
                                    <th width="30%" class="sorting" data-sorting_type="asc" data-column_name="name"
                                        style="cursor: pointer">Name <span id="post_title_icon"></span></th>
                                    <th width="10%" class="sorting" data-sorting_type="asc" data-column_name="role_id"
                                        style="cursor: pointer">Role ID <span id="post_title_icon"></span></th>
                                    <th width="15%" class="sorting" data-sorting_type="asc" data-column_name="email"
                                        style="cursor: pointer">Email <span id="post_title_icon"></span></th>
                                    <th width="15%" class="sorting" data-sorting_type="asc"
                                        data-column_name="phoneNumber" style="cursor: pointer">Phone Number <span
                                            id="post_title_icon"></span></th>
                                    <th width="10%" class="sorting" data-sorting_type="asc" data-column_name="date"
                                        style="cursor: pointer">Entry Date <span id="post_title_icon"></span></th>
                                    <th width="10%" class="sorting" data-sorting_type="asc" data-column_name="status"
                                        style="cursor: pointer">Status <span id="post_title_icon"></span></th>
                                    <th width="5%" class="sorting" data-sorting_type="asc" data-column_name="user_id"
                                        style="cursor: pointer">Action <span id="post_title_icon"></span></th>

                                </tr>
                            </thead>
                            <tbody>
                                @include('admin.pages.user.search_user_data')
                            </tbody>
                        </table>
                        <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
                        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="user_id" />
                        <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="phoneNumber" />
                        <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
                    </div>
                </div>
            </div>
        </div>
    </div><!-- End Row-->
</div>
<div class="modal fade" id="modal-animation-3">
    <form id="cform">
        {{ csrf_field() }}
        <div class="modal-dialog">
            <div class="modal-content animated">
                <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white"><i class="fa fa-star"></i> User</h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="Xlarge-input" class="col-form-label">Name</label>

                        <input type="text" id="name" name="name" placeholder="Full Name" required style="width: 100%;">
                        <input type="hidden" class="form-control" id="user_id" name="user_id">

                    </div>

                    <div class="form-group">
                        <label for="Xlarge-input" class="col-form-label">Email</label>
                        <input type="email" id="email" name="email" placeholder="Email" required style="width: 100%;">


                    </div>


                    <div class="form-group">
                        <label for="Xlarge-input" class="col-form-label">Mobile</label>

                        <input type="email" id="mobile" name="mobile" placeholder="Email" required style="width: 100%;">


                    </div>

                    <div class="form-group">
                        <label for="Xlarge-input">username</label>

                        <input type="text" id="username" placeholder="username" name="username" required style="width: 100%;">


                    </div>
                    <div class="form-group">
                        <label for="Xlarge-input">user_pic</label>
                        <input type="file" id="user_pic" style="width: 100%;" name="user_pic">


                    </div>

                    <div class="form-group">
                        <label for="Xlarge-input">Role</label>

                        <select id="role_id" name="role_id" style="width: 100%;">
                            <option value="">Select Role</option>
                            <?php
                                          foreach ($role as $val) {
                                              ?>
                            <option value="<?php echo $val->role_id; ?>"><?php echo $val->role_name; ?></option>

                            <?php
                                          }
                                          ?>
                        </select>

                    </div>
                    <div class="form-group">
                        <label for="large-input" class="col-form-label">Status</label>

                        <select id="status" name="status" style="width: 100%;">
                            <option value='1'>Active</option>
                            <option value='0'>Inactive</option>
                        </select>

                    </div>
                    <div class="form-group">
                        <label for="Xlarge-input" class="col-sm-3 col-form-label">Password</label>

                        <input type="password" id="password" name="password" required style="width: 100%;" placeholder="Enter your Password">


                    </div>


                </div>
                <div class="modal-footer">
                    <div id="showmsg" style="text-align: center;"></div>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i>
                        Close</button>
                    <button type="submit" class="btn btn-primary btn-submit"><i class="fa fa-check-square-o"></i> Save
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>
</div>
</div>
<script src="{{asset(url('admin/assets/js/jquery.min.js'))}}"></script>
<script src="{{asset(url('admin/search/userSearch.js'))}}"></script>
<script>
// ajax post
$(".btn-submit").click(function(e) {
    e.preventDefault();
    var _token = $("input[name='_token']").val();
    var name = $("input[name=name]").val();
    var phoneNumber = $("input[name=phoneNumber]").val();
    var user_pic = $("input[name=user_pic]").val();
    var role_id = $("select[name=role_id]").val();
    var status = $("select[name=status]").val();
    var email = $("input[name=email]").val();
    var mobile = $("input[name=mobile]").val();
    var password = $("select[name=password]").val();
    var user_id = $("input[name=user_id]").val();
    if (name == '') {
        alert("Please input your speciality name");
    }
    $.ajax({
        type: 'POST',
        url: "save-user",
        dataType: "json",
        data: {
            _token: _token,
            name: name,
            phoneNumber: phoneNumber,
            user_pic: user_pic,
            role_id: role_id,
            email: email,
            mobile: mobile,
            status: status,
            user_id: user_id,
            password: password
        },
        success: function(data) {
            var msg = data;
            var user_id = $("#user_id").val();
            if (user_id) {
                alert(data);
                location.reload().delay(3000);
            } else {
                $("#showmsg").text(msg);
                $("#cform")[0].reset();
                $("#name").focus();
            }

        }
    });
});

// Edit
function getbyId(user_id) {
    var _token = $("input[name='_token']").val();
    $.ajax({
        type: 'GET',
        dataType: "json",
        url: "user/searchuser_id/" + user_id,
        data: {
            "user_id": user_id,
            "_token": _token,
        },
        success: function(data) {
            $("#name").val(data.name);
            $("#name").val(data.name);
            $("#phoneNumber").val(data.phoneNumber);
            $("#user_pic").val(data.user_pic);
            $("#role_id").val(data.role_id);
            $("#status").val(data.status);
            $("#email").val(data.email);
            $("#mobile").val(data.mobile);
            $("#password").val(data.password);
            $("#user_id").val(data.user_id);

        }
    });
    $('#modal-animation-3').modal('show');
}
</script>

@endsection