<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>{{$title}}</title>
    <style type="text/css">
        .page-break {
            page-break-after: always;
        }
        .header{
            text-align: center;
            align-items: center;
        }
        h1{
            padding: 0;
            margin: 0;
        }
        table{
            width: 100%;
            border-collapse: collapse;
        }
        table td, th {
            border: 1px solid black;
            text-align: center;
        }
        .text-right{
            text-align: right !important;
        }
        .text-left{
            text-align: left !important;
        }
        footer {
            position: fixed;
            bottom: -10px;
            left: 0px;
            right: 0px;
            height: 1px;
        }
        .footer-inner {
            position: absolute;
            bottom: 40px;
            width: 100%;
        }
        .text-bold{
            font-weight: 600;
            color: green;
        }
    </style>
</head>
<body>
    <div class="main_container">
        <div class="header">
            <h3>WellFood Sylhet</h3>
            <div id="address">
                Sayra Monzil, 59 Dishary, Hawapara, Sylhet-3100
            </div><br/>
            <div id="address">
                @if(isset($date_show))
                <span>{{ $date_show }}</span>
                @endif
            </div>
        </div>
        <h2 style="margin-bottom: 5px !important; margin-bottom: 5px !important; padding-bottom: 5px !important" align="center">
            {{$title}}:  
            @if( $outlet_wise && $outlet)
                {{ $outlet->name }}
            @endif
            @if( $product_wise && $product)
                / {{ $product->product_name }}
            @endif

            
        </h2>
        <div class="page_break">
            <div class="test_details" style="margin-top: 10px;">
                <table>
                    <tr>
                        <th>ID</th>
                        <th>Date</th>
                        @if(Auth::user()->role == 1 && !$outlet_wise)
                        <th>Outlet Name</th>
                        @endif
                        <th>Total Bill</th>
                        <th>Paid</th>                        
                        <th>Discount</th>
                        <th>Revenue</th>
                        <th>Vat</th>
                        <th>Bill Type</th>                        
                    </tr>
                    @if(count($orders))
                    @php 
                        $total_rev = 0; 
                        $revenue = 0;
                        $total_bill_vat = 0; 
                        $total_bill_for_this_report = 0;
                        $total_paid_for_this_report = 0;
                        $total_due_for_this_report = 0;
                        $total_paid_cash = 0;
                        $total_paid_bkash = 0;
                        $total_paid_card = 0;
                    @endphp
                    @foreach($orders as $key=>$list)
                        @php 
                            $org_price = ($list->order_details)? $list->order_details->sum('price') : 0;                             
                            $revenue = ($list->total_bill - $list->discount) - $org_price - $list->bill_vat; 
                            $total_rev = $total_rev + $revenue;
                            $total_bill_vat = $total_bill_vat + ($list->bill_vat)? $list->bill_vat: 0;
                            $total_bill_for_this_report = $total_bill_for_this_report + ( $list->total_bill - $list->discount);
                            $total_paid_for_this_report = $total_paid_for_this_report + $list->advanceAmt;

                            $total_due_for_this_report = $total_due_for_this_report + $list->dueAmt;

                            if($list->bill_type == "Cash"){
                                $total_paid_cash = $total_paid_cash + $list->advanceAmt;
                            }
                            if($list->bill_type == "Bkash"){
                                $total_paid_bkash = $total_paid_bkash + $list->advanceAmt;
                            }
                            if($list->bill_type == "Card"){
                                $total_paid_card = $total_paid_card + $list->advanceAmt;
                            }
                            
                           
                        @endphp                    
                    <tr>
                        <td>{{ ++$key }}</td>
                        <td>{{ $list->invoice_date }}</td>
                        @if(Auth::user()->role == 1 && !$outlet_wise)
                        <td>{{ $list->outlet->name }}</td>
                        @endif                       
                        <td>{{ number_format($list->total_bill - $list->discount) }}</td>
                        <td>{{ number_format($list->advanceAmt) }}</td>
                        <td>{{ number_format($list->discount) }}</td>
                        <td>{{ number_format($revenue) }}</td>
                        <td>{{ number_format($list->bill_vat) }}</td>
                        <td>{{ $list->bill_type }}</td>
                    </tr>
                    @endforeach
                    <tr>
                        @if(Auth::user()->role == 1 && !$outlet_wise)
                            <td colspan="3" class="text-right"><b>Total: </b> </td>
                        @endif
                        @if(Auth::user()->role == 1 && $outlet_wise)
                        <td colspan="2" class="text-right"><b>Total: </b> </td>
                        @endif
                        <td class="text-bold">
                            <center>{{ number_format($total_bill_for_this_report) }}/-</center>
                        </td>
                        <td>
                            <center>{{number_format($total_paid_for_this_report)}}/-</center>
                        </td>  
                        <td>
                            <center>{{number_format($total_due_for_this_report)}}/-</center>
                        </td> 
                        <td>
                            <center>{{number_format($total_rev)}}/-</center>
                        </td>       
                        <td>
                            <center>{{number_format($total_bill_vat)}}/-</center>
                        </td>                           
                        <td colspan="2"> </td>
                    </tr>                   
                    <tr>
                        <td colspan="3" class="text-right"><b>Cash: </b> </td>
                        <td>
                            
                        </td>
                        <td>
                            <center>{{number_format($total_paid_cash)}}/-</center>
                        </td>                                  
                        <td colspan="5"> </td>
                    </tr>
                    <tr>
                        <td colspan="3" class="text-right"><b>Bkash: </b> </td>
                        <td>
                            
                        </td>
                        <td>
                            <center>{{number_format($total_paid_bkash)}}/-</center>
                        </td>                                  
                        <td colspan="5"> </td>
                    </tr>
                    <tr>
                        <td colspan="3" class="text-right"><b>Card: </b> </td>
                        <td>
                            
                        </td>
                        <td>
                            <center>{{number_format($total_paid_card)}}/-</center>
                        </td>                                  
                        <td colspan="5"> </td>
                    </tr>
                    @endif
                </table>
            </div>
        </div>

        <!--Footer-->
        <footer id="footer">
            <div class="footer-inner">
                <hr style="width: 200px;margin-left: 0;background: black;" size="1"/>
                <span style="margin-left: 50px;">Manager Signature</span>
            </div>
            <div align="right">

            <small style="text-align: right; font-size: 10px; font-family: monospace;">print date: {{\Carbon\Carbon::now()}}</small>
            </div>
        </footer>
    </div>
</body>
</html>