@extends('admin.master')
@section('title',$title)
@section('maincontent')

<div class="content-wrapper">
  <!-- End Breadcrumb-->
  <div class="card">
    <div class="card-body">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h3>
        Invoice
        <small>#000{{$order->invoice_id}}</small>
      </h3>
    </section>
    <!-- Main content -->
    <section class="invoice">
      <!-- title row -->
      <div class="row mt-3">
        <div class="col-lg-6">
          <h4><i class="fa fa-globe"></i> WellFood Sylhet</h4>
        </div>
          <div class="col-lg-6">
            <h5 class="float-sm-right">Date: {{ $order->invoice_date }}</h5>
          </div>
        </div>

        <!-- Table row -->
        <div class="row">
          <div class="col-12 table-responsive">
            <table class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Product</th>
                  <th>Qty</th>
                  <th>Price</th>
                  <th>Subtotal</th>
                </tr>
              </thead>
              <tbody>
                @foreach($order_details as $key => $list)
                <tr>
                  <td>{{ ++$key }}</td>
                  <td>{{ $list->product->product_name }}</td>
                  <td>{{ $list->qnty }}</td>
                  <td>{{ $list->rate }}</td>
                  <td>{{ $list->qnty * $list->rate }}</td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div><!-- /.col -->
        </div><!-- /.row -->

        <div class="row">
          <!-- accepted payments column -->
          <div class="col-lg-6 payment-icons">
            <p class="lead">Payment Methods:</p>
            <h4>{{$order->bill_type}}</h4>
            
          </div><!-- /.col -->
          <div class="col-lg-6" style="margin-top: 10px;">
            {{-- <p class="lead">Amount Due 2/22/2014</p> --}}
            <div class="table-responsive">
              <table class="table table-bordered">
                <tbody>
                  <tr>
                    <th style="width:50%">Subtotal:</th>
                    <td>{{ $order_details->sum('rate') }}</td>
                  </tr>
                <tr>
                  <th>Tax</th>
                  <td>{{ $order->bill_vat }}</td>
                </tr>
                
                <tr>
                  <th>Total:</th>
                  <td>{{ $order->total_bill }}</td>
                </tr>

                <tr>
                  <th>Paid:</th>
                  <td>{{ $order->advanceAmt }}</td>
                </tr>

                <tr>
                  <th>Due:</th>
                  <td>{{ $order->dueAmt }}</td>
                </tr>

              </tbody>
          </table>
            </div>
          </div><!-- /.col -->
        </div><!--/.row -->

        <!-- this row will not appear when printing -->
        <hr>
        
      </section><!-- /.content -->
    </div>
  </div>
    
</div>

@endsection