@extends('admin.master')
@section('title', $title)
@push('css')
<link href="{{asset('admin/assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}" rel="stylesheet" type="text/css">
<style type="text/css">
    .required{
        color: red;
        font-weight: 600;
    }
</style>
@endpush

@section('maincontent')

<div class="content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <form method="GET">
                            <div class="row">
                                <div class="col-md-4">
                                    <div id="dateragne-picker">
                                        <div class="input-daterange input-group">
                                            <input type="text" class="form-control" value="{{ ($request->start)?: '' }}" name="start" />
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">to</span>
                                            </div>
                                            <input type="text" class="form-control" value="{{ ($request->end)?: '' }}" name="end" />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <select class="form-control" name="outlet">
                                        <option value="">Select Outlet</option>
                                        @foreach($outlets as $out)
                                        <option value="{{ $out->id }}" {{ ($request->outlet == $out->id)? "selected" : "" }}>{{ $out->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 form-inline">
                                    <button type="submit" class="btn btn-success"><i class="fa fa-search"></i></button>
                                    <a href="{{ url('admin/outlets-daily-stock') }}" class="btn btn-danger" style="margin-left: 5px; color: #fff;"><i class="fa fa-refresh"></i></a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">{{ $title }} List</h5>
                        <div style="margin-right:110px;">
                            <button class="btn btn-info btn-sm" style="margin-top: -45px; float: right;" data-toggle="modal" data-target="#uploadStockFileModal"><i class="fa fa-plus"></i>Upload Stock File</button>
                        </div>
                        <div>
                            <button class="btn btn-info btn-sm" style="margin-top: -45px; float: right;" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Add New</button>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Date</th>
                                        <th>Outlet Name</th>
                                        <th>Product Name</th>
                                        <th>Fact. Rec. Qty</th>
                                        <th>Usable Qty</th>
                                        <th>Sold Out</th>
                                        <th>Waste</th>
                                        <th>Return</th>                      
                                        <th>Action</th>                                     
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($outlet_stocks as $key => $list)
                                        @php
                                            $sold_out = $list->fac_rec_qty - ($list->usable_qty + $list->waste_qty + $list->return_qty );
                                        @endphp
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ date('M d y',strtotime($list->date)) }}</td>
                                        <td>@if($list->outlet) {{ $list->outlet->name }} @endif</td>
                                        <td>@if($list->product)
                                            {{ $list->product->product_name }} @endif
                                        </td>
                                        <td>
                                            {{ ($list->fac_rec_qty)? $list->fac_rec_qty : 0 }}
                                            @if($list->product)
                                                {{ $list->product->base_unit }} 
                                            @endif
                                        </td>
                                        <td>{{ $list->usable_qty }}</td>
                                        <td>{{ $sold_out }}</td>
                                        <td>{{ ($list->waste_qty )? $list->waste_qty: 0 }}</td>
                                        <td>{{ ($list->return_qty )? $list->return_qty: 0 }}</td>                                        
                                        <td>                                            
                                            <button class="btn btn-primary btn-sm" onclick="return editData({{json_encode($list)}})"><i class="fa fa-edit"></i></button>
                                            {{-- <button class="btn btn-danger waves-effect btn-sm" onclick="return deleteCertification(<?php echo $list->id  ; ?>)"><i style="font-size: 15px;" class="fa fa-trash"></i></button>
                                            <form id="delete-form-{{$list->id  }}" action="{{url('admin/outlets-daily-stock',$list->id  )}}" method="post" style="display: none;">
                                                @method('DELETE')
                                                @csrf
                                            </form> --}}
                                        </td>                                       
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="paginate" style="float: right;">
                            {{ $outlet_stocks->appends(Request::except('page'))->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div><!--End Row-->
        <div class="overlay toggle-menu"></div>

        <div class="modal fade" id="addModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Add {{ $title }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('admin/outlets-daily-stock') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Date <span class="required"></span></label>
                                <input type="text" name="date" class="form-control" value="{{ date('d-M-y') }}" readonly="">
                            </div>
                            <div class="form-group">
                                <label>Product Name <span class="required">*</span></label>
                                <select name="product_id" class="form-control select2 base_unit">
                                    <option value="">Select Product</option>
                                    @foreach($products as $prod)
                                    <option value="{{ $prod->product_id }}">{{ $prod->product_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @if(Auth::user()->role == 1)
                            <div class="form-group">
                                <label>Outlet Name <span class="required">*</span></label>
                                <select name="outlet_id" class="form-control select2">
                                    <option value="">Select Product</option>
                                    @foreach($outlets as $out)
                                    <option value="{{ $out->id }}">{{ $out->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif
                            <div class="form-group">   
                                <label>Factory Received Qty <span class="required">*</span></label> <br/> 
                                <div style="float: left">         
                                    <input type="number" step="any" name="fac_rec_qty" step="any" class="form-control" placeholder="Enter Factory Received Qty" required="">
                                </div>
                                <div class="base_unit_label">
                                    <label id="base_unit_label"></label>
                                </div>
                            </div>                            
                        </div>  
                        <div class="clearfix">   </div><br/>
                        <div class="modal-footer">
                            <input type="hidden" name="base_unit" id="base_unit"/>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>
        <div class="modal fade" id="uploadStockFileModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Upload Today's Stock File</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('admin/upload-daily-stock-file') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Date <span class="required"></span></label>
                                <input type="text" name="date" class="form-control" value="{{ date('d-M-y') }}" readonly="">
                            </div>                            
                            @if(Auth::user()->role == 1)
                            <div class="form-group">
                                <label>Outlet Name <span class="required">*</span></label>
                                <select name="outlet_id" class="form-control select2">
                                    <option value="">Select Product</option>
                                    @foreach($outlets as $out)
                                    <option value="{{ $out->id }}">{{ $out->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif
                            <div class="form-group">
                                <label>Excel File</label>
                                <input type="file" class="form-control" name="stock_file">
                            </div>
                        </div>  
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>


        <div class="modal fade" id="editModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Update {{ $title }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('admin/outlets-daily-stock-update') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                           <div class="form-group">
                                <label>Date <span class="required"></span></label>
                                <input type="text" name="date" class="form-control" id="date" readonly="">
                            </div>
                            {{-- <div class="form-group">
                                <label>Product Name <span class="required">*</span></label>
                                <select name="product_id" id="product_id" class="form-control select2">
                                    <option value="">Select Product</option>
                                    @foreach($products as $prod)
                                    <option value="{{ $prod->product_id }}">{{ $prod->product_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @if(Auth::user()->role == 1)
                            <div class="form-group">
                                <label>Outlet Name <span class="required">*</span></label>
                                <select name="outlet_id" id="outlet_id" class="form-control select2">
                                    <option value="">Select Product</option>
                                    @foreach($outlets as $out)
                                    <option value="{{ $out->id }}">{{ $out->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif
                            <div class="form-group">
                                <label>Factory Received Qty <span class="required">*</span></label>
                                <input type="number" name="fac_rec_qty" step="any" id="fac_rec_qty" class="form-control" placeholder="Enter Factory Received Qty" required="">
                            </div> --}}
                            <div class="form-group">
                                <label>Waste Qty <span class="required">*</span></label><br/>
                                <div style="float: left">
                                    <input type="number" step="any" name="waste_qty" id="waste_qty" class="form-control" placeholder="Enter Waste Qty">
                                </div>
                                <div class="base_unit_label">
                                    <label id="base_unit_label_waste_qty"></label>
                                </div>
                            </div>
                            <div class="clearfix"></div><br/>
                            <div class="form-group">
                                <label>Return Qty <span class="required">*</span></label><br/>
                                <div style="float: left">
                                    <input type="number" step="any" name="return_qty" id="return_qty" class="form-control" placeholder="Enter Return Qty">
                                </div>
                                <div class="base_unit_label">
                                    <label id="base_unit_label_return_qty"></label>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <input type="hidden" id="old_return_qty" name="old_return_qty" />
                        <input type="hidden" id="old_waste_qty" name="old_waste_qty" />
                        <input type="hidden" name="outlet_stocks_id" id="outlet_stocks_id">
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>
    </div>
    <!--end overlay-->
</div>
<!-- End container-fluid-->

@endsection

@push('js')
    <script src="{{asset('admin/assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
    <script type="text/javascript">
        $('#inline-datepicker').datepicker({
            todayHighlight: true
        });

        $('#dateragne-picker .input-daterange').datepicker({});
    </script>
    <script type="text/javascript">
        $(document).ready(function(){
            $('.select2').select2();
        });

        $( ".base_unit" ).change(function() {        
            var product_id = $('.base_unit').find(":selected").val();
            
            $.ajax({
                type: "POST",
                url: '/get-product-data-by-item-name',
                data: {
                    "_token": "{{ csrf_token() }}",
                    item_name: product_id,
                },
                success: function(response) {
                    if(response){
                        console.log(response.data);
                        $.each( response.data, function( key, value ) {
                           $('#base_unit_label').text(value.base_unit);
                           $('#base_unit').val(value.base_unit);
                        });                  
                    }else{
                        alert(response.message)
                    }
                }
            });
                
        });
        function editData(value){
            $('#editModal').modal('show');
            $('#outlet_stocks_id').val(value.id);
            $('#date').val(value.date);
            $('#product_id').val(value.product_id);
            $('#outlet_id').val(value.outlet_id);
            $('#fac_rec_qty').val(value.fac_rec_qty);
            $('#waste_qty').val(value.waste_qty);
            $('#return_qty').val(value.return_qty);

            $('#old_waste_qty').val(value.waste_qty);
            $('#old_return_qty').val(value.return_qty);            
            $('.select2').select2();
            if(value.product){
                $('#base_unit_label_waste_qty').text(value.product.base_unit);
                $('#base_unit_label_return_qty').text(value.product.base_unit);
            }
        }

    </script>
@endpush