@extends('admin.master')
@section('title',$title)
@section('maincontent')
@push('css')
<link href="{{asset('admin/assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css')}}" rel="stylesheet" type="text/css">
@endpush
<div class="content-wrapper">
    <div class="container-fluid">
    	<!-- Breadcrumb-->
     	
     	<div class="row">
     		<div class="col-md-12">
     			<div class="card">
     				<div class="card-header">Outlet Wise Revenue Report</div>
     				<div class="card-body">
     					<form method="GET" action="{{ url('admin/report/revenue-report') }}" target="_blank">
	     					<div class="row">
	     						<div class="col-md-4">
							        <div id="dateragne-picker">
							         	<div class="input-daterange input-group">
							          		<input type="text" class="form-control" name="start" />
						          			<div class="input-group-prepend">
							           			<span class="input-group-text">to</span>
							          		</div>
							          		<input type="text" class="form-control" name="end" />
							         	</div>
							       	</div>
	     						</div>
	     						@if(Auth::user()->role == 1)
	     						<div class="col-md-2">
	     							<select class="form-control select2" name="outlet">
	     								<option value="">Select Outlet</option>
	     								@foreach($outlets as $out)
	     								<option value="{{ $out->id }}">{{ $out->name }}</option>
	     								@endforeach
	     							</select>
	     						</div>
	     						@endif
	     						<div class="col-md-2">
	     							<select class="form-control select2" name="product">
	     								<option value="">Select Product</option>
	     								@foreach($products as $prod)
	     								<option value="{{ $prod->product_id }}">{{ $prod->product_name }}</option>
	     								@endforeach
	     							</select>
	     						</div>
	     						<div class="col-md-2 form-inline">
	     							<button type="submit" class="btn btn-success"><i class="fa fa-search"></i></button>
	     							<a href="{{ url('admin/orders') }}" class="btn btn-danger" style="margin-left: 5px; color: #fff;"><i class="fa fa-refresh"></i></a>
	     						</div>
	     					</div>
     					</form>
     				</div>
     			</div>
     		</div>
     	</div>
	    <!-- End Breadcrumb-->

	</div>
	<!-- End container-fluid-->
    
</div>

@endsection

@push('js')
	<script src="{{asset('admin/assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>
	<script type="text/javascript">
		$(document).ready(function(){
		    $('.select2').select2();
		});
		$('#inline-datepicker').datepicker({
         	todayHighlight: true
      	});

      	$('#dateragne-picker .input-daterange').datepicker({});
	</script>
@endpush