<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>{{$title}}</title>
    <style type="text/css">
        .page-break {
            page-break-after: always;
        }
        .header{
            text-align: center;
            align-items: center;
        }
        h1{
            padding: 0;
            margin: 0;
        }
        table{
            width: 100%;
            border-collapse: collapse;
        }
        table td, th {
            border: 1px solid black;
            text-align: center;
        }
        .text-right{
            text-align: right !important;
        }
        .text-left{
            text-align: left !important;
        }
        footer {
            position: fixed;
            bottom: -10px;
            left: 0px;
            right: 0px;
            height: 1px;
        }
        .footer-inner {
            position: absolute;
            bottom: 40px;
            width: 100%;
        }
    </style>
</head>
<body>
    <div class="main_container">
        <div class="header">
            <h3>WellFood Sylhet</h3>
            <div id="address">
                Sayra Monzil, 59 Dishary, Hawapara, Sylhet-3100
            </div>
        </div>
        <h2 style="margin-bottom: 5px !important; margin-bottom: 5px !important; padding-bottom: 5px !important" align="center">{{$title}}: </h2>
        <div class="page_break">
            <div class="test_details" style="margin-top: 10px;">
                <table>
                    <tr>
                        <th>SL</th>
                        <th>Outlet Name</th>
                        <th>Total Bill</th>
                        <th>Paid</th>
                        <th>Due</th>
                        <th>Revenue</th>
                    </tr>
                    @foreach($orders as $key => $list)
                    <tr>
                        <td>{{++$key}}</td>
                        <td>{{ $list->outlet->name }}</td>
                        <td>{{ number_format((int)$list->sum('total_bill')) }}</td>
                        <td>{{ number_format((int)$list->sum('advanceAmt')) }}</td>
                        <td>{{ number_format((int)$list->sum('dueAmt')) }}</td>
                        <td>{{ '2' }}</td>
                    </tr>
                    @endforeach
                </table>
            </div>
        </div>

        <!--Footer-->
        <footer id="footer">
            <div class="footer-inner">
                <hr style="width: 200px;margin-left: 0;background: black;" size="1"/>
                <span style="margin-left: 50px;">Manager Signature</span>
            </div>
            <div class="footer-inner">
                <hr style="width: 200px;margin-left: 0;background: black;" size="1"/>
                <span style="margin-left: 50px;">MD Signature</span>
            </div>
            <div align="right">

            <small style="text-align: right; font-size: 10px; font-family: monospace;">print date: {{\Carbon\Carbon::now()}}</small>
            </div>
        </footer>
    </div>
</body>
</html>