<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\User;
use App\Models\HoldItem;
use App\Models\HoldItemHistory;
use App\Models\Product;
use DB;
use Auth;

class AjaxController extends Controller
{

  public function productSearchByName(Request $request){
    if(empty($request->value)){
      return response()->json(['status' => false, 'message' => 'Please Select Any value', 'data' => []]);
    }
    $product = Product::where('product_name','LIKE', '%'.$request->value.'%')->orderBy('product_name','asc')->orWhere('product_code', '%'.$request->value.'%')->get();
    if(count($product)){
      $output = '';
        $output .= "<div class='row' style='overflow: scroll;'>";
            foreach($product as $i) {

        $productName= $i->product_name;
        $product_id= $i->product_id;
        $product_data = json_encode($i);
        $output .= "<div class='col-md-6' style='padding: 1px;'>
                        <button type='button' class='btn btn-dark btn-lg btn-block waves-effect waves-light btn-size-own'
                        style='font-size: 13px; text-align: center;' onclick='getItemQty($product_data)'> $productName</button>
                </div>";
        }
        $output .= "</div>";
        $item_data = trim(preg_replace('/\s\s+/', ' ', $output));
        $data = array(
        'status' => true,
        'item_data' => $item_data,
        );
        echo json_encode($data);
    }else{
      return response()->json(['status' => false, 'message' => 'Product Not Found', 'data' => []]);
    }
  }



    public function checkuserName(Request $request){
        
        $user = auth()->user(); // or pass an actual user here

      	if (!\Hash::check($request->password, $user->password)) {
        	$data = "no";
        	echo json_encode($data);exit;
      	}else{
        	$response = User::where('username', $request->username)->first();
        	if ($response){
                $data = "yes";
            }else{
                $data = "no";
            }
            echo json_encode($data);
      	}
        
    }

    public function get_sub_category_by_category_id(Request $request){
      $data = DB::table('tbl_subcategory')->where('category_id', $request->category_id)->get();
      if(empty(count($data))){
          return response()->json(['status' =>false, 'message' => 'Sub Category not found', 'data' => []]);
      }else{
          return response()->json(['status' =>true, 'message' => 'Sub Category found', 'data' => $data]);
      }
    }

    public function catWiseItemAll(Request $request){
        
        
        if ($request->ajax()) {
          $category_id = $request->get('category_id');
            $qty = $request->get('qty');
          
            $allCategory= DB::table('tbl_product')
                    ->select(DB::raw('tbl_product.category_id,tbl_product.product_id,tbl_product.special_price,tbl_product.regular_price,tbl_product.product_name,tbl_product.qty'))
                    ->where('category_id',$category_id)->where('status',1)->orderBy('category_id', 'asc')->get();

            $output = '';
            $output .= "<div class='row' style='overflow: scroll;'>";
                foreach($allCategory as $i) {

            $productName= $i->product_name;
            $product_id= $i->product_id;
            $product_data = json_encode($i);
            $output .= "<div class='col-md-6' style='padding: 1px;'>
                            <button type='button' class='btn btn-dark btn-lg btn-block waves-effect waves-light btn-size-own'
                            style='font-size: 13px; text-align: center;' onclick='getItemQty($product_data)'> $productName</button>
                    </div>";
            }
            $output .= "</div>";
            $string = trim(preg_replace('/\s\s+/', ' ', $output));
            $data = array(
            'item_data' => $string,
            );
            echo json_encode($data);
      }
    }


    // Recal Onclick Action Start
    public function catWiseItemAlls(Request $request){
          
        $allCategory= DB::table('tbl_product')
                ->select(DB::raw('tbl_product.category_id,tbl_product.product_id,tbl_product.product_name,tbl_product.qty'))
                ->where('category_id',$category_id)->where('status',1)->orderBy('category_id', 'asc')->get();

            $output = '';
            $output .= "<div class='row' style='overflow: scroll;'>";
                foreach($allCategory as $i) {

            $productName= $i->product_name;
            $product_id= $i->product_id;

            $output .= "<div class='col-md-6' style='padding: 1px;'>
                            <button type='button' class='btn btn-dark btn-lg btn-block waves-effect waves-light btn-size-own'
                            style='font-size: 13px; text-align: center;' onclick='getItemQtyRecal($product_id,$hold_id)'> $productName</button>
                    </div>";
            }
            $output .= "</div>";
            $string = trim(preg_replace('/\s\s+/', ' ', $output));
            $data = array(
            'item_data' => $string,
            );
            echo json_encode($data);
                
      }

    public function ProductSearchRecall(Request $request){

        
        if ($request->ajax()) {
           $product_id = $request->get('product_id');
           $hold_id = $request->get('hold_id');
           $qty = $request->get('qty');
          
        if(!empty($qty)){
           $products= DB::table('tbl_product')
                        ->select(DB::raw('tbl_product.regular_price,tbl_product.product_id'))
                        ->where('product_id',$product_id)->where('status',1)->first();
                        
            $uId =  Auth::user()->id;            
            $chk=  DB::table('tbl_hold_history')->where('user_id',$uId)->where('product_id',$product_id)->first(); 
                        
             if(empty($chk->product_id)){
                    $data = array();           
                    $data['user_id']= Auth::user()->id;
                    $data['qnty']= $qty;
                    $data['product_id']= $products->product_id;
                    $data['hold_id']= $hold_id;
                    $data['rate']= $products->regular_price;
                    $data['total']= $qty * $products->regular_price;
                    DB::table('tbl_hold_history')->insert($data);
                    // logodata
                    $logdata = array();
                    $logdata['user_id'] =  Auth::user()->id;
                    $logdata['role_id'] = Auth::user()->role_id;
                    $logdata['action'] = "Recall";
                    $logdata['details'] = "User Clicking Item";
                    $logdata['date_time'] =date("F j, Y, g:i a");
                    $logdata['date'] = date("Y-m-d");
                    $logdata['ip'] = getHostByName(getHostName());
                    DB::table('tbl_logdata')->insert($logdata);
               
                }else{
                    DB::table('tbl_hold_history')->where('tbl_hold_history.product_id',$products->product_id)->where('tbl_hold_history.user_id',$uId)->delete();                
                }           
            
            $userId= Auth::user()->id;
            $draftproducts=  DB::table('tbl_hold_history')
                            ->leftJoin('tbl_product', 'tbl_product.product_id', '=', 'tbl_hold_history.product_id')
                            ->where('tbl_hold_history.user_id',$userId)
                            ->where('tbl_hold_history.hold_id',$hold_id)
                            ->get();
            $orderCount = $draftproducts->count();                
            $output = '';
            $output .= "<div style='overflow: scroll;height: 350px;'>
                                <table border='1' style='width: 100%; font-family: Courier New, monospace;'>
                                    <thead>
                                         <tr style='background-color: green; color: white;'>
                                            <th scope='col'>#</th>
                                            <th scope='col'>Item Name</th>
                                            <th scope='col'><center>Qty</center></th>
                                            <th scope='col'><center>Price</center></th>
                                            <th scope='col'><center>x</center></th>
                                         
                                        </tr>
                                    </thead>";
                                  
                                  $x=1;
                                  $sum=0;
                       foreach($draftproducts as $i){             
                                    $poductName=$i->product_name;
                                    $total= $i->total;
                                    $qnty= $i->qnty;
                                    $sum += $total;
                                    $productId= $i->product_id;
                        $output .="<tbody>
                                   <tr>
                                       <th scope='row'>$x</th>
                                       <td>$poductName</td>
                                        <td><center>$qnty</center></td>
                                       <td><center>$total</center></td>
                                       <td onclick='removeRecallProductId($productId)'><center><i aria-hidden='true' class='fa fa-remove' style='color: red;'></i></center></td>
                                   </tr>
                               </tbody>";
                               $x++;
                               }
                                                    
                        $output .="</table>
                                      </div>";
                                      
            $string = trim(preg_replace('/\s\s+/', ' ', $output));
           // $pecentageValue =  (5 / 100) * $sum;
           // $totalbil= $pecentageValue + $sum;
           $percentOut=  (5 / 100) * $sum;
           $pecentageValue = intval($percentOut);
           $totalbil= $pecentageValue + $sum;
            
            $data = array(
            'draftItem' => $string,
            'item_total' => $sum,
            'pecentage_value' => $pecentageValue,
            'total_bill' => $totalbil,
            'orderCount' => $orderCount,
            );
            echo json_encode($data);
        }else{
                echo json_encode('qty_empty');
        }  
      }
    }


     public function ProductId(Request $request){
        
      
        if ($request->ajax()) {
           $product_id = $request->get('product_id');
           $qty = $request->get('qty');

          
        if(!empty($qty)){
           $products= DB::table('tbl_product')
                        ->select(DB::raw('tbl_product.regular_price,tbl_product.product_id'))
                        ->where('product_id',$product_id)->where('status',1)->first();
                        
                        
            $uId= Auth::user()->id;            
            $chk=  DB::table('tbl_invoice_draft')->where('user_id',$uId)->where('product_id',$product_id)->first(); 
                        
             if(empty($chk->product_id)){
                    $data = array();           
                    $data['user_id']= Auth::user()->id;
                    $data['qnty']= $qty;
                    $data['product_id']= $products->product_id;;
                    $data['rate']= $products->regular_price;
                    $data['total']= $qty * $products->regular_price;
                    DB::table('tbl_invoice_draft')->insert($data);
                    // logodata
                    $logdata = array();
                    $logdata['user_id'] =  Auth::user()->id;
                    $logdata['role_id'] = Auth::user()->role_id;
                    $logdata['action'] = "Draft";
                    $logdata['details'] = "User Clicking Item";
                    $logdata['date_time'] =date("F j, Y, g:i a");
                    $logdata['date'] = date("Y-m-d");
                    $logdata['ip'] = getHostByName(getHostName());
                    DB::table('tbl_logdata')->insert($logdata);
               
                }else{
                    DB::table('tbl_invoice_draft')->where('tbl_invoice_draft.product_id',$products->product_id)->where('tbl_invoice_draft.user_id',$uId)->delete();                
                }           
            
            $userId= Auth::user()->id;
            $draftproducts=  DB::table('tbl_invoice_draft')
                            ->leftJoin('tbl_product', 'tbl_product.product_id', '=', 'tbl_invoice_draft.product_id')
                            ->where('tbl_invoice_draft.user_id',$userId)->get();
            $orderCount = $draftproducts->count();                
            $output = '';
            $output .= "<div style='overflow: scroll;height: 350px;'>
                                <table border='1' style='width: 100%; font-family: Courier New, monospace;'>
                                    <thead>
                                         <tr style='background-color: green; color: white;'>
                                            <th scope='col'>#</th>
                                            <th scope='col'>Item Name</th>
                                            <th scope='col'><center>Qty</center></th>
                                            <th scope='col'><center>Price</center></th>
                                            <th scope='col'><center>x</center></th>
                                         
                                        </tr>
                                    </thead>";
                                  
                                  $x=1;
                                  $sum=0;
                       foreach($draftproducts as $i){             
                                    $poductName=$i->product_name;
                                    $total= $i->total;
                                    $qnty= $qty;
                                    $sum += $total;
                                    $productId= $i->product_id;
                        $output .="<tbody>
                                   <tr>
                                       <th scope='row'>$x</th>
                                       <td>$poductName</td>
                                        <td><center>$qnty</center></td>
                                       <td><center>$total</center></td>
                                       <td onclick='removeProductId($productId)'><center><i aria-hidden='true' class='fa fa-remove' style='color: red;'></i></center></td>
                                   </tr>
                               </tbody>";
                               $x++;
                               }
                                                    
                        $output .="</table>
                                      </div>";
                                      
           //  $string = trim(preg_replace('/\s\s+/', ' ', $output));
           // // $pecentageValue =  (5 / 100) * $sum;
           // // $totalbil= $pecentageValue + $sum;
           // $percentOut=  (5 / 100) * $sum;
           // $pecentageValue = intval($percentOut);
           // $totalbil= $pecentageValue + $sum;
            
            $data = array(
            'data' => true,
            // 'draftItem' => $string,
            // 'item_total' => $sum,
            // 'pecentage_value' => $pecentageValue,
            // 'total_bill' => $totalbil,
            // 'orderCount' => $orderCount,
            );
            echo json_encode($data);
        }else{
          echo json_encode('qty_empty');
        }  
      }

    }


    public function settelItemList(Request $request){
        
        
        if ($request->ajax()) {
        $query = $request->get('query');
        $hold_id = $request->get('hold_id');

        $userId= Auth::user()->id;

        if($query==1){

                $draftproducts=  DB::table('tbl_invoice_draft')
                            ->leftJoin('tbl_product', 'tbl_product.product_id', '=', 'tbl_invoice_draft.product_id')
                            ->where('tbl_invoice_draft.user_id',$userId)->get();
        }else if($query==2){

            $draftproducts=  DB::table('tbl_hold_history')
                            ->leftJoin('tbl_product', 'tbl_product.product_id', '=', 'tbl_hold_history.product_id')
                            ->where('tbl_hold_history.user_id',$userId)
                            ->where('tbl_hold_history.hold_id',$hold_id)
                            ->get();
        }

        $orderCount = $draftproducts->count();


        $setting=  DB::table('tbl_setting')->first();
        $img = asset('admin/'.$setting->photo); 
        $address = Auth::user()->outlet->address;
        $output = '';
        $output .= "<center><img src='$img' style='width: 50px; height: 50; margin-left: -10px;'></center>";
        $output .= "<center style='font-family: Courier New, monospace;'><h5 style='font-family: monospace;'>Franchise of SHA Global BD Ltd.</h5><p style='margin-bottom: 0px; width: 60%;'>$address</p></center>";
        $output .= "<center><hr></center>";
        $output .= "<table border='0' style='width: 270px; color: black; font-family: Courier New, monospace; font-size: 13px;'>
                                    <thead>
                                      <tr style='color: black;'>
                                            <th scope='col'>#</th>
                                            <th scope='col'>Item Name</th>
                                              <th scope='col'><center>Qty</center></th>
                                            <th scope='col'>Price</th>
                                        </tr>
                                    </thead>";
                                  $x=1;
                                  $sum=0;
                                  $specialpr=0;
                                  
                       foreach($draftproducts as $i){             
                                    $poductName=$i->product_name;
                                    $total= $i->total;
                                    $qnty= $i->qnty;
                                    $sum += $total;
                                    $productId= $i->product_id;
                                    $qnty= $i->qnty;
                                    $rate= $i->rate;
                                    $specialpr += $i->special_price;
                        $output .="<tbody>
                                   <tr>
                                       <th scope='row'>$x</th>
                                       <td>$poductName
                                         <input type='hidden' name='product_id[]' value='$productId'>
                                         <input type='hidden' name='qnty[]' value='$qnty'>
                                         <input type='hidden' name='rate[]' value='$rate'>
                                       </td>
                                         <td style='text-align: right;'>$qnty</td>
                                       <td style='text-align: right;'>$total</td>
                                   </tr>
                               </tbody>";
                               $x++;
                               }             
                        $output .="</table>";
            
            $pecentageValue =  (5 / 100) * $sum;
            $totalbil= $pecentageValue + $sum;
         //   $discount = $sum - $specialpr
            $output .= "<table border='0' style='width: 270px; margin-top: 10px; color: black; font-family: Courier New, monospace;'>
              <tbody>
                  <tr>
                      <td style='width: 50%'>Total</td>
                      <td style='width: 50%; text-align: right; font-weight: bold;'>$sum BDT</td>
                  </tr>
                  <tr>
                      <td style='width: 50%'>VAT 5 %</td>
                      <td style='width: 50%; text-align: right; font-weight: bold;'>$pecentageValue BDT</td>
                  </tr>
                  <tr>
                      <td style='width: 50%'>Discount</td>
                      <td style='width: 50%; text-align: right; font-weight: bold;'>$specialpr BDT</td>
                  </tr>
                  <tr>
                      <td style='width: 50%'>Grand Total</td>
                      <td style='width: 50%; text-align: right; font-weight: bold;'>$totalbil BDT</td>
                  </tr>
              </tbody>
          </table>";
                                   
     $string = trim(preg_replace('/\s\s+/', ' ', $output));                                 
          
            $data = array(
            'table_draftitem' => $string,
            'item_total' => $sum,
            'vat_calcuate' => $pecentageValue,
            'grand_total_bill' => $totalbil,
            );
            echo json_encode($data);
        
      }
    }


    public function removeProIdFrmHold(Request $request){

    
    if ($request->ajax()) {
            $product_id = $request->get('product_id');
            $hold_id = $request->get('hold_id');

            $userId= Auth::user()->id;
            DB::table('tbl_hold_history')
                    ->where('tbl_hold_history.product_id',$product_id)
                    ->where('tbl_hold_history.user_id',$userId)->delete();
        // logodata
          $logdata = array();
          $logdata['user_id'] =  Auth::user()->id;
          $logdata['role_id'] = Auth::user()->role_id;
          $logdata['action'] = "Remove";
          $logdata['details'] = "User Remove Hold Item";
          $logdata['date_time'] =date("F j, Y, g:i a");
          $logdata['date'] = date("Y-m-d");
          $logdata['ip'] = getHostByName(getHostName());
          DB::table('tbl_logdata')->insert($logdata);
            // reload table
        $draftproducts=  DB::table('tbl_hold_history')
                    ->leftJoin('tbl_product', 'tbl_product.product_id', '=', 'tbl_hold_history.product_id')
                    ->where('tbl_hold_history.hold_id',$hold_id)
                    ->where('tbl_hold_history.user_id',$userId)->get();

      
        $orderCount = $draftproducts->count();  

        $output = '';
        $output .= "<div style='overflow: scroll;height: 350px;'>
                            <table border='1' style='width: 100%; font-family: Courier New, monospace;'>
                                <thead>
                                  <tr style='background-color: green; color: white;'>
                                        <th scope='col'>#</th>
                                        <th scope='col'>Item Name</th>
                                         <th scope='col'><center>Qty</center></th>
                                        <th scope='col'>Price</th>
                                        <th scope='col'><center>x</center></th>
                                    </tr>
                                </thead>";
                              
                              $x=1;
                              $sum=0;
                   foreach($draftproducts as $i){             
                                $poductName=$i->product_name;
                                $total= $i->total;
                                $qty =  $i->qnty;
                                $sum += $total;
                                $productId= $i->product_id;
                                $holdId= $i->hold_id;
                              
                    $output .="<tbody>
                               <tr>
                                   <th scope='row'>$x</th>
                                   <td>$poductName</td>
                                   <td><center>$qty</center></td>
                                   <td><center>$total</center></td>
                                   <td onclick='removeRecallProductId($productId,$holdId)'><center><i aria-hidden='true' class='fa fa-remove' style='color: red;'></i></center></td>
                               </tr>
                           </tbody>";
                           $x++;
                           }
                                                
                    $output .="</table>
                                  </div>";
                                  
        $string = trim(preg_replace('/\s\s+/', ' ', $output));
        $percentOut=  (5 / 100) * $sum;
        $pecentageValue = intval($percentOut);
        $totalbil= $pecentageValue + $sum;
        
        $data = array(
        'draftItem' => $string,
        'item_total' => $sum,
        'pecentage_value' => $pecentageValue,
        'total_bill' => $totalbil,
        'orderCount' => $orderCount,
        );
        echo json_encode($data);

    }
}

public function removeProId(Request $request){
        
        
        if ($request->ajax()) {
                $product_id = $request->get('product_id');
                $userId= Auth::user()->id;
                DB::table('tbl_invoice_draft')->where('tbl_invoice_draft.product_id',$product_id)->where('tbl_invoice_draft.user_id',$userId)->delete();
            // logodata
              $logdata = array();
              $logdata['user_id'] =  Auth::user()->id;
              $logdata['role_id'] = Auth::user()->role_id;
              $logdata['action'] = "Remove";
              $logdata['details'] = "User Remove Draft Item";
              $logdata['date_time'] =date("F j, Y, g:i a");
              $logdata['date'] = date("Y-m-d");
              $logdata['ip'] = getHostByName(getHostName());
              DB::table('tbl_logdata')->insert($logdata);
                // reload table
        
            $draftproducts=  DB::table('tbl_invoice_draft')
                        ->leftJoin('tbl_product', 'tbl_product.product_id', '=', 'tbl_invoice_draft.product_id')
                        ->where('tbl_invoice_draft.user_id',$userId)->get();
            $orderCount = $draftproducts->count();  

            $output = '';
            $output .= "<div style='overflow: scroll;height: 350px;'>
                                <table border='1' style='width: 100%; font-family: Courier New, monospace;'>
                                    <thead>
                                      <tr style='background-color: green; color: white;'>
                                            <th scope='col'>#</th>
                                            <th scope='col'>Item Name</th>
                                             <th scope='col'><center>Qty</center></th>
                                            <th scope='col'>Price</th>
                                            <th scope='col'><center>x</center></th>
                                        </tr>
                                    </thead>";
                                  
                                  $x=1;
                                  $sum=0;
                       foreach($draftproducts as $i){             
                                    $poductName=$i->product_name;
                                    $total= $i->total;
                                    $qty =  $i->qnty;
                                    $sum += $total;
                                    $productId= $i->product_id;
                        $output .="<tbody>
                                   <tr>
                                       <th scope='row'>$x</th>
                                       <td>$poductName</td>
                                       <td><center>$qty</center></td>
                                       <td><center>$total</center></td>
                                       <td onclick='removeProductId($productId)'><center><i aria-hidden='true' class='fa fa-remove' style='color: red;'></i></center></td>
                                   </tr>
                               </tbody>";
                               $x++;
                               }
                                                    
                        $output .="</table>
                                      </div>";
                                      
            $string = trim(preg_replace('/\s\s+/', ' ', $output));
            $percentOut=  (5 / 100) * $sum;
            $pecentageValue = intval($percentOut);
            $totalbil= $pecentageValue + $sum;
            
            $data = array(
            'draftItem' => $string,
            'item_total' => $sum,
            'pecentage_value' => $pecentageValue,
            'total_bill' => $totalbil,
            'orderCount' => $orderCount,
            );
            echo json_encode($data);

        }
        
    }

    public function ClearAll(Request $request){        
        if ($request->ajax()) {
           $number = $request->get('number');
           $userId= Auth::user()->id;
           DB::table('tbl_invoice_draft')->where('tbl_invoice_draft.user_id',$userId)->delete();
             // logodata
             $logdata = array();
             $logdata['user_id'] =  Auth::user()->id;
             $logdata['role_id'] = Auth::user()->role_id;
             $logdata['action'] = "Clear All ";
             $logdata['details'] = "User Remove All Item [Draft]";
             $logdata['date_time'] =date("F j, Y, g:i a");
             $logdata['date'] = date("Y-m-d");
             $logdata['ip'] = getHostByName(getHostName());
             DB::table('tbl_logdata')->insert($logdata);
            //reload data
            $draftproducts=  DB::table('tbl_invoice_draft')
                        ->leftJoin('tbl_product', 'tbl_product.product_id', '=', 'tbl_invoice_draft.product_id')
                        ->where('tbl_invoice_draft.user_id',$userId)->get();
            $orderCount = $draftproducts->count();  

            $output = '';
            $output .= "<div style='overflow: scroll;height: 350px;'>
                                <table border='1' style='width: 100%; font-family: Courier New, monospace;'>
                                    <thead>
                                      <tr style='background-color: green; color: white;'>
                                            <th scope='col'>#</th>
                                            <th scope='col'>Item Name</th>
                                             <th scope='col'><center>Qty</center></th>
                                            <th scope='col'>Price</th>
                                            <th scope='col'><center>x</center></th>
                                        </tr>
                                    </thead>";
                                  
                                  $x=1;
                                  $sum=0;
                       foreach($draftproducts as $i){             
                                    $poductName=$i->product_name;
                                    $total= $i->total;
                                    $qty =  $i->qnty;
                                    $sum += $total;
                                    $productId= $i->product_id;
                        $output .="<tbody>
                                   <tr>
                                       <th scope='row'>$x</th>
                                       <td>$poductName</td>
                                       <td><center>$qty</center></td>
                                       <td><center>$total</center></td>
                                       <td onclick='removeProductId($productId)'><center><i aria-hidden='true' class='fa fa-remove' style='color: red;'></i></center></td>
                                   </tr>
                               </tbody>";
                               $x++;
                               }
                                                    
                        $output .="</table>
                                      </div>";
                                      
            $string = trim(preg_replace('/\s\s+/', ' ', $output));
            $percentOut=  (5 / 100) * $sum;
            $pecentageValue = intval($percentOut);
            $totalbil= $pecentageValue + $sum;
            
            $data = array(
            'draftItem' => $string,
            'item_total' => $sum,
            'pecentage_value' => $pecentageValue,
            'total_bill' => $totalbil,
            'orderCount' => $orderCount,
            );
            echo json_encode($data);
                       
        }
        
    }

    public function ShowReCallItem(Request $request){

            if ($request->ajax()) {
                $query = $request->get('hold_id');
                $userId= Auth::user()->id;
                $draftproducts=  DB::table('tbl_hold_history')
                            ->leftJoin('tbl_product', 'tbl_product.product_id', '=', 'tbl_hold_history.product_id')
                            ->where('tbl_hold_history.user_id',$userId)
                            ->where('tbl_hold_history.hold_id',$query)
                            ->get();

                $orderCount = $draftproducts->count();
                
                $output = '';
                $output .= " <table border='1' style='width: 100%; font-family: Courier New, monospace;'>
                                            <thead>
                                            <tr style='background-color: green; color: black;'>
                                                    <th scope='col'>#</th>
                                                    <th scope='col'>Item Name</th>
                                                      <th scope='col'><center>Qty</center></th>
                                                    <th scope='col'>Price</th>
                                                    <th scope='col'><center>x</center></th>
                                                </tr>
                                            </thead>";
                                          $x=1;
                                          $sum=0;
                                          $specialpr=0;
                                          
                               foreach($draftproducts as $i){             
                                            $poductName=$i->product_name;
                                            $total= $i->total;
                                            $qnty= $i->qnty;
                                            $sum += $total;
                                            $productId= $i->product_id;
                                            $qnty= $i->qnty;
                                            $rate= $i->rate;
                                            $specialpr += $i->special_price;
                                            $holdId= $i->hold_id;
                                $output .="<tbody>
                                           <tr>
                                               <th scope='row'>$x</th>
                                               <td>$poductName
                                                 <input type='hidden' name='product_id[]' value='$productId'>
                                                 <input type='hidden' name='qnty[]' value='$qnty'>
                                                 <input type='hidden' name='rate[]' value='$rate'>
                                               </td>
                                                 <td style='text-align: right;'>$qnty</td>
                                               <td style='text-align: right;'>$total</td>
                                               <td onclick='removeRecallProductId($productId,$holdId)'><center><i aria-hidden='true' class='fa fa-remove' style='color: red;'></i></center></td>
                                           </tr>
                                       </tbody>";
                                       $x++;
                                       }             
                                $output .="</table>";
               
                    $percentOut=  (5 / 100) * $sum;
                    $pecentageValue = intval($percentOut);
                    $totalbil= $pecentageValue + $sum;

                 $output .= "<table border='0' style='width: 100%; margin-top: 10px; color: black; font-family: Courier New, monospace;'>
                      <tbody>
                          <tr>
                              <td style='width: 50%'>Total</td>
                              <td style='width: 50%; text-align: right; font-weight: bold;'>$sum BDT</td>
                          </tr>
                          <tr>
                              <td style='width: 50%'>VAT 5 %</td>
                              <td style='width: 50%; text-align: right; font-weight: bold;'>$pecentageValue BDT</td>
                          </tr>
                          <tr>
                              <td style='width: 50%'>Discount</td>
                              <td style='width: 50%; text-align: right; font-weight: bold;'>$specialpr BDT</td>
                          </tr>
                          <tr>
                              <td style='width: 50%'>Grand Total</td>
                              <td style='width: 50%; text-align: right; font-weight: bold;'>$totalbil BDT</td>
                          </tr>
                      </tbody>
                  </table>";
                                           
             $string = trim(preg_replace('/\s\s+/', ' ', $output));   
                                     
             $data = array(
                'recallData' => $string,
                'item_total' => $sum,
                'pecentage_value' => $pecentageValue,
                'total_bill' => $totalbil,
                'orderCount' => $orderCount
                );
             echo json_encode($data);
                
              }

       }

       public function InsertHoldInvoice(){
        $data=array();
        $data['user_id']=  Auth::user()->id;
        $data['entry_date']= date("Y-m-d");

        $holdId = DB::table('tbl_hold')->insertGetId($data);

        $user_id =  Auth::user()->id;
        $allitem= DB::table('tbl_invoice_draft')
                        ->where('user_id',$user_id)->get();
        
        foreach($allitem as $i){
            $data2 = array(
                'product_id' => $i->product_id,
                'qnty' => $i->qnty,
                'rate' => $i->rate,
                'total' => $i->total,
                'hold_id' => $holdId,
                'user_id' => $user_id
            );
            DB::table('tbl_hold_history')->insert($data2);
        }

        // logodata
        $logdata = array();
        $logdata['user_id'] =  Auth::user()->id;
        $logdata['role_id'] = Auth::user()->role_id;
        $logdata['action'] = "Hold";
        $logdata['details'] = "User Create Hold Item";
        $logdata['date_time'] =date("F j, Y, g:i a");
        $logdata['date'] = date("Y-m-d");
        $logdata['ip'] = getHostByName(getHostName());
        DB::table('tbl_logdata')->insert($logdata);

        echo json_encode("insert Hold history");

    }

    public function holdlist(Request $request){
        
        
          if ($request->ajax()) {
              
              $userId= Auth::user()->id;
              $hold_item = HoldItem::where('user_id', $userId)->get();
              // $holdItems =  DB::table('tbl_hold')
              //                  ->select(DB::raw('users.id,tbl_hold.hold_id,tbl_hold.entry_date,tbl_hold_history.product_id,tbl_hold_history.qnty,tbl_hold_history.rate,tbl_hold_history.total'))
              //                 ->leftJoin('tbl_hold_history', 'tbl_hold_history.hold_id', '=', 'tbl_hold.hold_id')
              //                 ->leftJoin('users', 'users.id', '=', 'tbl_hold_history.user_id')
              //                 ->where('tbl_hold_history.user_id',$userId)->get();

            // return $hold_item;                  
              $output = '';
              $output .= "<div style='overflow: scroll;height: 350px;'>
                                  <table border='1' style='width: 100%; font-family: Courier New, monospace;'>
                                      <thead>
                                           <tr style='background-color: green; color: white;'>
                                              <th scope='col'><center>Hold ID</center></th>
                                              <th scope='col'><center>Total Bill</center></th>
                                              <th scope='col'><center>Entry Date</center></th>
                                              <th scope='col'><center>Prepared by</center></th>
                                          </tr>
                                      </thead>";
                                    $x=1;
                                    $sum=0;
                         foreach($hold_item as $item){ 
                              //  $billTotal = DB::table('tbl_hold')->where('tbl_hold_history.user_id',$userId)->where('tbl_hold_history.hold_id',$i->hold_id)->sum('tbl_hold_history.total');;
                            


                                      $entry_date= date("d-m-Y",strtotime($item->entry_date));
                                      $sum = ($item->item_history)? $item->item_history->sum('total') : 0 ;
                                      $hold_id = $item->hold_id;
                                      $user_name = $item->user->name;
                          $output .="<tbody>
                                     <tr onclick='getAllHoldItem($hold_id)'>
                                         <th scope='row'><center>$x [$hold_id]</center></th>
                                         <td style='text-align: right;'>$sum BDT</td>
                                         <td><center>$entry_date</center></td>
                                         <td><center> $user_name </center></td>
                                     </tr>
                                 </tbody>";
                                 $x++;
                                 }
                                                      
                          $output .="</table>
                                        </div>";
                                        
              $string = trim(preg_replace('/\s\s+/', ' ', $output));
           
             $percentOut=  (5 / 100) * $sum;
             $pecentageValue = intval($percentOut);
             $totalbil= $pecentageValue + $sum;
              
              $data = array(
              'hold_item_list' => $string,
              );
              echo json_encode($data);
          
        }
    }





} //class end
