<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use Auth;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Writer\Xls;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {        
        $data['title'] = 'Product';    
        $products = Product::orderBy('sort','ASC')->where('status', 1);
        if($request->product){
            $products = $products->where('product_name', 'like', '%' . $request->product . '%')->orWhere('product_code', 'like', '%' . $request->product . '%');
        }
        $data['products'] = $products->paginate(20);
        $data['search_product'] = $request->product ? $request->product : '';
        $data['categories'] = Category::where('status', 1)->get();
        return view('admin.pages.products', $data);
    }
    public function productsSortUpdate(Request $request){
        $return_array['success'] = 'Successfully Sorting Updated';
        foreach ($request->product_sort_data as $key => $product_sort_data) {
            $product = Product::where('product_id', $product_sort_data['product_id']);
            $sort_data['sort'] = $product_sort_data['sort'];
            $product->update($sort_data);  
        }       
        return $return_array;
    }
    public function downloadDailyStockImport(){
        $data['title'] = 'Daily Stock Import';
        $data['products'] = Product::orderBy('sort','ASC')->where('status', 1)->get();
        $data['categories'] = Category::where('status', 1)->get();
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A1', 'Id');
        $sheet->setCellValue('B1', 'Product Name');
        $sheet->setCellValue('C1', 'Factory Receive Quantity');

        $rows = 2;

        foreach($data['products'] as $product ){   
            $status = ( $product->status == '1' ) ? 'Active' : 'In Active';       
            $sheet->setCellValue('A' . $rows, $product->product_id);
            $sheet->setCellValue('B' . $rows, $product->product_name); 
            $sheet->setCellValue('C' . $rows, $product->fac_rec_qty);           
            $rows++;
        }
        $type = 'xlsx';
        $fileName = "daily_stock_import.".$type;
        if($type == 'xlsx') {
        $writer = new Xlsx($spreadsheet);
        } else if($type == 'xls') {
        $writer = new Xls($spreadsheet);
        }
        $writer->save($fileName);
        header("Content-Type: application/vnd.ms-excel");
        return redirect(url('/')."/".$fileName);
    }
    public function download(){
        $data['title'] = 'Product';
        $data['products'] = Product::orderBy('product_id','desc')->where('status', 1)->get();
        $data['categories'] = Category::where('status', 1)->get();
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A1', 'Id');
        $sheet->setCellValue('B1', 'Category');
        $sheet->setCellValue('C1', 'Product Name');
        $sheet->setCellValue('D1', 'Code');
        $sheet->setCellValue('E1', 'Regular Price');
        $sheet->setCellValue('F1', 'Special Price');
        $sheet->setCellValue('G1', 'Factory Price');
        $sheet->setCellValue('H1', 'Status');

        $rows = 2;

        foreach($data['products'] as $product ){   
            $status = ( $product->status == '1' ) ? 'Active' : 'In Active';       
            $sheet->setCellValue('A' . $rows, $product->product_id);
            $sheet->setCellValue('B' . $rows, $product->category->category_name);
            $sheet->setCellValue('C' . $rows, $product->product_name);
            $sheet->setCellValue('D' . $rows, $product->product_code);
            $sheet->setCellValue('E' . $rows, $product->regular_price);
            $sheet->setCellValue('F' . $rows, $product->special_price);
            $sheet->setCellValue('G' . $rows, $product->orginal_price);
            $sheet->setCellValue('H' . $rows, $status);
            $rows++;
        }
        $type = 'xlsx';
        $fileName = "products.".$type;
        if($type == 'xlsx') {
        $writer = new Xlsx($spreadsheet);
        } else if($type == 'xls') {
        $writer = new Xls($spreadsheet);
        }
        $writer->save($fileName);
        header("Content-Type: application/vnd.ms-excel");
        return redirect(url('/')."/".$fileName);
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new Product();
        $data->user_id = Auth::user()->id;
        $data->category_id = $request->category;
        $data->sub_cat_id = $request->sub_cat_id ;
        $data->product_name = $request->name;
        $data->product_code = $request->code;
        $data->special_price = $request->special_price;
        $data->regular_price = $request->regular_price;
        $data->orginal_price = $request->original_price;
        $data->price_perpc = $request->price_perpc;
        $data->original_price_perpc = $request->original_price_perpc;        
        $data->weight_perpc = $request->weight_perpc;
        $data->base_unit = $request->base_unit;        
        // $data->per_kg_price = $request->per_kg_price;
        $data->status = $request->status;

        $doc = $request->file('image');
        if(isset($doc)){
            $doc_name = uniqid().'.'.$doc->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('uploads', $doc, $doc_name);
            $data->photo = $doc_name;
        }

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Product Added');
        return redirect()->back();
    }

  

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data = Product::findOrFail($request->product_id);
        $data->category_id = $request->category;
        $data->sub_cat_id = $request->sub_cat_id ;
        $data->product_name = $request->name;
        $data->product_code = $request->code;
        $data->special_price = $request->special_price;
        $data->regular_price = $request->regular_price;
        $data->orginal_price = $request->original_price;
        $data->price_perpc = $request->price_perpc;
        $data->original_price_perpc = $request->original_price_perpc;
        $data->weight_perpc = $request->weight_perpc;
        $data->base_unit = $request->base_unit; 
        // $data->per_kg_price = $request->per_kg_price;
        $data->status = $request->status;

        $doc = $request->file('image');
        if(isset($doc)){
            if (Storage::disk('public')->exists('uploads/'.$data->photo)) {
                Storage::disk('public')->delete('uploads/'.$data->photo);
            }
            $doc_name = uniqid().'.'.$doc->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('uploads', $doc, $doc_name);
            $data->photo = $doc_name;
        }

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Product Added');
        return redirect()->back();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Product::findOrFail($id);
        if (Storage::disk('public')->exists('uploads/'.$data->photo)) {
            Storage::disk('public')->delete('uploads/'.$data->photo);
        }
        try {
            $data->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Product Deleted');
        return redirect()->back();
    }
}
