<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Outlet;
use App\User;
use Auth;

class OutletController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = 'Outlet';
        $data['outlets'] = Outlet::orderBy('id','desc')->get();
        return view('admin.pages.outlets', $data);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);

        $data = new Outlet();
        $data->name = $request->name;
        $data->address = $request->address;
        $data->status = $request->status;
        $data->created_by = Auth::user()->id;

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Outlet Added');
        return redirect()->back();

    }

 
    public function update(Request $request)
    {
        $data = Outlet::findOrFail($request->outlet_id);
        $data->name = $request->name;
        $data->address = $request->address;
        $data->status = $request->status;

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Outlet Updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Outlet $outlet)
    {
        try {
            $outlet->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Outlet Deleted');
        return redirect()->back();
        
    }
}
