<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use Auth;

class CategotyController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = 'Category';
        $data['categories'] = Category::orderBy('category_id','desc')->paginate(20);
        return view('admin.pages.categories', $data);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $data = new Category();
        $data->category_name = $request->name;
        $data->class = $request->btn_color;
        $data->status = $request->status;

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Category Added');
        return redirect()->back();

    }

 
    public function update(Request $request)
    {
        $data = Category::findOrFail($request->Category_id);
        $data->user_id = $request->Category_admin;
        $data->name = $request->name;
        $data->address = $request->address;
        $data->status = $request->status;

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Category Updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Category $category)
    {
        try {
            $category->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Category Deleted');
        return redirect()->back();
        
    }
}
