<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = 'tbl_product';
    protected $primaryKey = 'product_id';
    public $timestamps = false;

    public function setProductNameAttribute($value){
        $this->attributes['product_name'] = $value;
        $this->attributes['slug'] = $this->slugify($value);
    }

    private function slugify($value){
        $slug = str_replace(' ', '-', strtolower($value));
        $count = Product::where('slug', 'LIKE','%'.$slug.'%')->count();
        $suffix = $count ? $count+1 : '';
        $slug .= $suffix;
        return $slug;
    }

    public function category(){
    	return $this->belongsTo(Category::class, 'category_id')->withDefault();
    }

    public function sub_category(){
    	return $this->belongsTo(SubCategory::class, 'sub_cat_id')->withDefault();
    }

    public function has_stock(){
        return $this->hasOne(OutletStock::class, 'product_id')->where('date', date('Y-m-d'));
    }
}
