<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use DB;
use Auth;

class HomeController extends Controller
{
  
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function create_invoice_new(){
        $data['title'] = 'Create Invoice';
        return view('admin.pages.sales.create_invoice', $data);
    }

    public function dashboard()
    {
        $data['title'] = "Dashboard";
        //dd(bcrypt('123456'));
        return view('admin.child', $data);
    }

    public function makeNewGraphRpt(){
        $this->AuthCheck();
        $results = DB::select( DB::raw("SELECT tbl_category.category_name, SUM(tbl_order_details.price) AS productPrice
             FROM tbl_product LEFT JOIN tbl_category ON tbl_category.category_id = tbl_product.category_id 
             LEFT JOIN tbl_order_details ON tbl_order_details.product_id = tbl_product.product_id 
             LEFT JOIN tbl_order ON tbl_order.order_id = tbl_order_details.order_id 
             WHERE tbl_category.status = 1 AND tbl_category.category_type = 1 
             AND tbl_order.status=2 GROUP BY tbl_product.category_id "));
            $data = array();
            foreach($results as $i){
                    $x= $i->category_name;
                    $y= $i->productPrice;
                    $data[] = array($x, $y);
            }

            echo json_encode($data,JSON_NUMERIC_CHECK );
     
    }

    public function get_user(){
        $user = User::with("outlet")->whereId(Auth::user()->id)->first();
        return $user;
    }
}
