<?php

namespace App\Http\Controllers\Api;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;
use App\Models\Order;
use App\Models\OrderDetails;
use App\Models\OutletStock;
use Auth;
use DB;

class PosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getCategory()
    {
        //return Category::with('product:product_id,category_id,product_name,special_price,regular_price')->orderBy('category_name','asc')->get();
        return Category::with('product')->orderBy('category_name','asc')->get();
    }

    public function search_product($query = null){
        if($query){
            return Product::where('product_name','LIKE', '%'.$query.'%')->orWhere('product_name','LIKE', '%'.$query.'%')->get();
        }else{
            return Product::orderBy('product_name','asc')->get();
        }
    }
    protected function getProductInfo(Request $request){
        return Product::where('product_name',$request->item_name)
          ->orWhere('product_code', $request->item_name)
          ->orWhere('product_id', $request->item_name)->get();
    }
    public function saveInvoice(Request $request){        
        if(empty(count($request->cart_item))){
            return response()->json(['status' => false, 'message' => 'cart is empty', 'data' => [] ]);
        }
        if(empty(Auth::user())){
            return response()->json(['status' => false, 'message' => 'Your Session is over, please login again', 'data' => [] ]);   
        }
        DB::beginTransaction();
        $order = new Order();
        $order->outlet_id = Auth::user()->outlet_id;
        $order->user_id = Auth::user()->id;
        $order->invoice_date = date('Y-m-d');
        $order->total_bill = $request->cartTotal;
        $order->discount = $request->discount_amount;
        $order->return_amount = $request->return_amount;        
        $order->advanceAmt = $request->advance_amount;
        $order->bill_type = ( $request->payment_type ? $request->payment_type : 'Cash');

        try {
            $order->save();
        } catch (ModelNotFoundException $e) {
            DB::rollback();
            return response()->json(['status' => false, 'message' => $e->message(), 'data' => [] ]);   
        }

        foreach ($request->cart_item as $key => $value) {
            $product = Product::where('product_id', $value['id'])->first();
            $sold_qty = $value['qty']; 
            
            $orginal_price = $product->orginal_price;
            if( $value['base_unit'] == "Kg" && $value['sale_unit'] == "Pc" ){
                $sold_qty = ($value['weight_perpc'] * $value['qty'])/1000;
                $orginal_price = $product->original_price_perpc;
            }
            
            $order_detail = new OrderDetails();
            $order_detail->InvoiceId = $order->invoice_id;
            $order_detail->user_id = Auth::user()->id;
            $order_detail->product_id = $value['id'];
            $order_detail->qnty = $value['qty'];
            $order_detail->rate = $value['price'];
            $order_detail->sub_total = $value['qty'] * $value['price'];
            $order_detail->price = $value['qty'] * $orginal_price;
            $order_detail->sale_unit = $value['sale_unit'];

            try {
                $order_detail->save();
                DB::table('outlet_stocks')->where('product_id', $value['id'])
                ->where('outlet_id', Auth::user()->outlet_id)
                ->update(array('usable_qty' => DB::raw('usable_qty - ' .$sold_qty)));

            } catch (ModelNotFoundException $e) {
                DB::rollback();
                return response()->json(['status' => false, 'message' => $e->message(), 'data' => [] ]);   
            }

            // $stock->usable_qty -= $value->qty;
            // try {
            //     $stock->save();
            // } catch (ModelNotFoundException $e) {
            //     DB::rollback();
            //     return response()->json(['status' => false, 'message' => $e->message(), 'data' => [] ]);   
            // }

        }

        DB::commit();
        return response()->json(['status' => true, 'message' => 'Successfully Save the order', 'data' => [] ]);   

    }

    
}
